using System;
using System.ComponentModel;
using System.Collections;
using Borland.Eco.Services;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.ObjectImplementation;
using Borland.Eco.UmlRt;
using Borland.Eco.UmlCodeAttributes;


namespace LazyFetchAlert
{

	[UmlCollection(typeof(Building))]
	public interface IBuildingList : ICollection
	{
		#region ECO generated code
		Building this[int index]
		{
			get;
			set;
		}
		int Add(Building value);
		bool Contains(Building value);
		int IndexOf(Building value);
		void Insert(int index, Building value);
		void Remove(Building value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}

	[UmlCollection(typeof(Person))]
	public interface IPersonList : ICollection
	{
		#region ECO generated code
		Person this[int index]
		{
			get;
			set;
		}
		int Add(Person value);
		bool Contains(Person value);
		int IndexOf(Person value);
		void Insert(int index, Person value);
		void Remove(Person value);
		void Clear();
		void RemoveAt(int index);
		#endregion ECO generated code
	}
	[UmlElement("Package", Id="cf5e5017-1a18-4a89-b475-4f0d8312cbbe")]
	[EcoCodeGenVersion("2.0")]
	[UmlMetaAttribute("ownedElement", typeof(Person))]
	[UmlMetaAttribute("ownedElement", typeof(Building))]
	public abstract class CoreClassesPackage
	{
		
		[UmlElement("Association", Id="eecde24a-0f22-4548-9c63-92d90b54c8df")]
		public class Residency
		{
		}
	}
	[UmlElement(Id="3f628ab0-7247-43ce-8617-ed4e46dde54f")]
	public class Person : ILoopBack
	{
		
		public class PersonListAdapter : ObjectListAdapter, IPersonList
		{
			public PersonListAdapter(IList source) : 
					base(source)
			{
			}
			public Person this[int index]
			{
				get
				{
					return ((Person)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Person value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Person value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Person value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Person value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Person value)
			{
				this.Adaptee.Remove(value);
			}
		}
		
		#region Autogenerated ECO code
		
		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
		
		public Person(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 2);
			public const int Name = Eco_FirstMember;
			public const int Home = (Name + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		
		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
		
		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
		
		#endregion Autogenerated ECO code
		
		public Person(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="9da80421-475e-4d4b-b193-4bdf20b992f6", Index=Eco_LoopbackIndices.Name)]
		[UmlMetaAttribute("initialValue", "<new person>")]
		public string Name
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Name)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Name, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Home, Id="1a02fba9-2c33-431c-8524-f41f590e5fd3")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Residency), Index=0)]
		[UmlMetaAttribute("multiplicity", "0..1")]
		public Building Home
		{
			get
			{
				return ((Building)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Home)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Home, ((object)(value)));
			}
		}
	}
	[UmlElement(Id="5d063912-32e8-445d-8d47-621f1fdee6f3")]
	[UmlTaggedValue("Eco.DefaultStringRepresentation", "address")]
	public class Building : ILoopBack
	{
		
		public class BuildingListAdapter : ObjectListAdapter, IBuildingList
		{
			public BuildingListAdapter(IList source) : 
					base(source)
			{
			}
			public Building this[int index]
			{
				get
				{
					return ((Building)(base.Adaptee[index]));
				}
				set
				{
					base.Adaptee[index] = value;
				}
			}
			public int Add(Building value)
			{
				return this.Adaptee.Add(value);
			}
			public bool Contains(Building value)
			{
				return this.Adaptee.Contains(value);
			}
			public int IndexOf(Building value)
			{
				return this.Adaptee.IndexOf(value);
			}
			public void Insert(int index, Building value)
			{
				this.Adaptee.Insert(index, value);
			}
			public void Remove(Building value)
			{
				this.Adaptee.Remove(value);
			}
		}
		
		#region Autogenerated ECO code
		
		public IObjectInstance AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		protected IContent eco_Content;
		
		public Building(IContent content)
		{
			this.eco_Content = content;
			content.AssertLoopbackUnassigned();
		}
		
		public struct Eco_LoopbackIndices
		{
			public const int Eco_FirstMember = 0;
			public const int Eco_MemberCount = (Eco_FirstMember + 2);
			public const int Address = Eco_FirstMember;
			public const int Residents = (Address + 1);
		}
		
		IObject IObjectProvider.AsIObject()
		{
			return this.eco_Content.AsIObject();
		}
		
		public virtual object get_MemberByIndex(int index)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		public virtual void set_MemberByIndex(int index, object value)
		{
			throw new System.IndexOutOfRangeException();
		}
		
		protected void Initialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content == null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				this.eco_Content = factory.CreateContent(this);
				this.eco_Content.LoopbackValid();
			}
		}
		
		protected void Deinitialize(IEcoServiceProvider serviceProvider)
		{
			if ((this.eco_Content != null))
			{
				IInternalObjectContentFactory factory = ((IInternalObjectContentFactory)(serviceProvider.GetEcoService(typeof(IInternalObjectContentFactory))));
				factory.CreateContentFailed(this.eco_Content, this);
				this.eco_Content = null;
			}
		}
		
		#endregion Autogenerated ECO code
		
		public Building(IEcoServiceProvider serviceProvider)
		{
			this.Initialize(serviceProvider);
			try
			{
			}
			catch (System.Exception )
			{
				this.Deinitialize(serviceProvider);
				throw;
			}
		}
		[UmlElement(Id="2a01f74d-c2b0-464d-8025-59defe645172", Index=Eco_LoopbackIndices.Address)]
		[UmlMetaAttribute("initialValue", "<new building>")]
		public string Address
		{
			get
			{
				return ((string)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Address)));
			}
			set
			{
				this.eco_Content.set_MemberByIndex(Eco_LoopbackIndices.Address, ((object)(value)));
			}
		}
		[UmlElement("AssociationEnd", Index=Eco_LoopbackIndices.Residents, Id="c8b28842-3199-48eb-8aec-2f4419f3db3d")]
		[UmlMetaAttribute("association", typeof(CoreClassesPackage.Residency), Index=1)]
		[UmlMetaAttribute("multiplicity", "0..*")]
		public IPersonList Residents
		{
			get
			{
				return new Person.PersonListAdapter(((IList)(this.eco_Content.get_MemberByIndex(Eco_LoopbackIndices.Residents))));
			}
		}
	}
}
